/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWInvokeInstruction;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.property.VWInvokeParamPanel;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VWInvokeAdvancedPanel
extends JPanel {
    private VWInvokeParamPanel m_parent = null;
    private VWInstructionDefinition m_instructionDef = null;
    private JTextField m_timeOutExpression = null;
    private JTextField m_timeOutMap = null;
    private JCheckBox m_useReliableMessagingUI = new JCheckBox();
    private boolean m_useReliableMessaging = false;

    public VWInvokeAdvancedPanel(VWInvokeParamPanel parent, VWInstructionDefinition instruction) {
        this.m_parent = parent;
        this.m_instructionDef = instruction;
        this.setupLayout();
    }

    public void setInstructionDefinition(VWInvokeInstruction instructionDef) {
        this.m_instructionDef = instructionDef;
        this.reinitialize();
    }

    private void setupLayout() {
        this.setLayout(new GridBagLayout());
        JLabel timeOutExpressionLabel = new JLabel(VWResource.s_timeOutExpressionColon);
        this.m_timeOutExpression = new JTextField();
        this.m_timeOutExpression.setEditable(false);
        this.m_timeOutExpression.setBorder(null);
        JPanel timeOutExpressionPanel = new JPanel(new BorderLayout(10, 0));
        timeOutExpressionPanel.add((Component)timeOutExpressionLabel, "Before");
        timeOutExpressionPanel.add((Component)this.m_timeOutExpression, "Center");
        JLabel timeOutMapLabel = new JLabel(VWResource.s_timeOutMapColon);
        this.m_timeOutMap = new JTextField();
        this.m_timeOutMap.setEditable(false);
        this.m_timeOutMap.setBorder(null);
        JPanel timeOutMapPanel = new JPanel(new BorderLayout(10, 0));
        timeOutMapPanel.add((Component)timeOutMapLabel, "Before");
        timeOutMapPanel.add((Component)this.m_timeOutMap, "Center");
        this.m_useReliableMessagingUI = new JCheckBox(VWResource.s_useReliableMessaging);
        this.m_useReliableMessagingUI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                VWInvokeAdvancedPanel.this.m_useReliableMessagingUI.setSelected(VWInvokeAdvancedPanel.this.m_useReliableMessaging);
            }
        });
        JPanel ws_messagingPanel = new JPanel(new BorderLayout(0, 0));
        ws_messagingPanel.add((Component)this.m_useReliableMessagingUI, "Last");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 23;
        c.gridwidth = 0;
        c.fill = 2;
        this.add((Component)timeOutExpressionPanel, c);
        ++c.gridy;
        this.add((Component)timeOutMapPanel, c);
        ++c.gridy;
        c.weighty = 1.0;
        this.add((Component)ws_messagingPanel, c);
    }

    private void reinitialize() {
        try {
            String timeOutExpression = ((VWInvokeInstruction)this.m_instructionDef).getTimeoutExpr();
            this.m_parent.setTextField(this.m_timeOutExpression, timeOutExpression);
            String timeOutMap = ((VWInvokeInstruction)this.m_instructionDef).getTimeoutMapName();
            this.m_parent.setTextField(this.m_timeOutMap, timeOutMap);
            boolean bUseReliableMessaging = ((VWInvokeInstruction)this.m_instructionDef).getUseReliableMessaging();
            this.m_useReliableMessagingUI.setSelected(bUseReliableMessaging);
            this.updateUI();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeReferences() {
        this.m_timeOutExpression = null;
        this.m_timeOutMap = null;
        this.m_useReliableMessagingUI = null;
        this.m_parent = null;
        this.m_instructionDef = null;
    }
}

